<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Bookings extends Model 
{

    protected $table = 'bookings';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'clinic_id', 'doctor_id', 'appointment_id', 'discount_id', 'price', 'status');

    public function user()
    {
        return $this->belongsTo('Users', 'user_id');
    }

    public function clinic()
    {
        return $this->belongsTo('Clinics', 'clinic_id');
    }

    public function doctor()
    {
        return $this->belongsTo('Doctors', 'doctor_id');
    }

    public function appointment()
    {
        return $this->belongsTo('Appointments', 'appointment_id');
    }

    public function discount()
    {
        return $this->belongsTo('Discounts', 'discount_id');
    }

}