<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Doctors extends Model 
{

    protected $table = 'doctors';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_en', 'name_ar', 'logo', 'clinic_id', 'brief', 'nationality', 'fees', 'email', 'rating', 'phone', 'waiting_time', 'degree_id');

    public function clinic()
    {
        return $this->belongsTo('Clinics', 'clinic_id');
    }

    public function degree()
    {
        return $this->belongsTo('Degree', 'degree_id');
    }

}