<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Specialities extends Model 
{

    protected $table = 'specialities';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_en', 'name_ar', 'icon', 'color', 'parent_id');

    public function parent()
    {
        return $this->belongsTo('Specialities', 'parent_id');
    }

}