<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdsTable extends Migration {

	public function up()
	{
		Schema::create('ads', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('clinic_id')->nullable();
			$table->integer('doctor_id')->nullable();
			$table->timestamp('start_at')->nullable();
			$table->timestamp('expire_at')->nullable();
			$table->integer('clicks')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('ads');
	}
}