<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Rate extends Model 
{

    protected $table = 'rate';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('booking_id', 'q1', 'q2', 'q3', 'q4', 'review');

    public function booking()
    {
        return $this->belongsTo('Bookings', 'booking_id');
    }

}