<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClinicsTable extends Migration {

	public function up()
	{
		Schema::create('clinics', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name_en')->nullable();
			$table->string('name_ar')->nullable();
			$table->text('logo')->nullable();
			$table->double('latitude')->nullable();
			$table->double('longitude')->nullable();
			$table->string('adress_en')->nullable();
			$table->string('adress_ar')->nullable();
			$table->integer('rating')->default('0');
			$table->integer('user_id');
			$table->decimal('fees')->default('0');
			$table->integer('waiting_time')->default('0');
			$table->string('email')->nullable();
			$table->string('phone')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('clinics');
	}
}