<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Ads extends Eloquent {

	protected $table = 'ads';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('clinic_id', 'doctor_id', 'start_at', 'expire_at', 'clicks');

	public function clinic()
	{
		return $this->belongsTo('Clinics', 'clinic_id');
	}

	public function doctor()
	{
		return $this->belongsTo('Doctors', 'doctor_id');
	}

}