<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Bookings extends Eloquent {

	protected $table = 'bookings';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'clinic_id', 'doctor_id', 'appointment_id', 'discount_id', 'price', 'status');

	public function user()
	{
		return $this->belongsTo('Users', 'user_id');
	}

	public function clinic()
	{
		return $this->belongsTo('Clinics', 'clinic_id');
	}

	public function doctor()
	{
		return $this->belongsTo('Doctors', 'doctor_id');
	}

	public function appointment()
	{
		return $this->belongsTo('Appointments', 'appointment_id');
	}

	public function discount()
	{
		return $this->belongsTo('Discounts', 'discount_id');
	}

}