<?php

namespace App;

class Offers extends Eloquent {

	protected $table = 'offers';
	public $timestamps = true;
	protected $fillable = array('image_en', 'image_ar', 'start_at', 'expire_at', 'discount_id', 'clinic_id', 'doctor_id', 'clicks');

	public function discount()
	{
		return $this->belongsTo('Discounts', 'discount_id');
	}

	public function clinic()
	{
		return $this->belongsTo('Clinics', 'clinic_id');
	}

	public function doctor()
	{
		return $this->belongsTo('Doctors', 'doctor_id');
	}

}