<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Ads extends Model 
{

    protected $table = 'ads';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('clinic_id', 'doctor_id', 'start_at', 'expire_at', 'clicks');

    public function clinic()
    {
        return $this->belongsTo('Clinics', 'clinic_id');
    }

    public function doctor()
    {
        return $this->belongsTo('Doctors', 'doctor_id');
    }

}