<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOffersTable extends Migration {

	public function up()
	{
		Schema::create('offers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->text('image_en')->nullable();
			$table->text('image_ar')->nullable();
			$table->timestamp('start_at')->nullable();
			$table->timestamp('expire_at')->nullable();
			$table->integer('discount_id');
			$table->integer('clinic_id')->nullable();
			$table->integer('doctor_id')->nullable();
			$table->integer('clicks')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('offers');
	}
}