<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDiscountsTable extends Migration {

	public function up()
	{
		Schema::create('discounts', function(Blueprint $table) {
			$table->timestamps();
			$table->increments('id');
			$table->softDeletes();
			$table->string('code')->nullable();
			$table->string('name')->nullable();
			$table->boolean('is_percent')->default(0);
			$table->decimal('amount')->default('0');
			$table->integer('clinic_id')->nullable();
			$table->integer('doctor_id')->nullable();
			$table->integer('uses')->default('0');
			$table->integer('max_uses')->default('0');
			$table->timestamp('start_at')->nullable();
			$table->timestamp('expire_at')->nullable();
			$table->integer('user_id');
		});
	}

	public function down()
	{
		Schema::drop('discounts');
	}
}