<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBookingsTable extends Migration {

	public function up()
	{
		Schema::create('bookings', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id');
			$table->integer('clinic_id')->nullable();
			$table->integer('doctor_id')->nullable();
			$table->integer('appointment_id');
			$table->integer('discount_id');
			$table->decimal('price');
			$table->enum('status', array('New', 'early_attended', 'attended', 'cancel'));
		});
	}

	public function down()
	{
		Schema::drop('bookings');
	}
}