<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('user_name');
			$table->string('password');
			$table->integer('mobile');
			$table->string('verification_code');
			$table->string('verified');
			$table->string('login');
			$table->string('active');
			$table->enum('role', array('admin', 'clinic', 'patient'));
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}