<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvitesTable extends Migration {

	public function up()
	{
		Schema::create('invites', function(Blueprint $table) {
			$table->char('code', 16)->primary();
			$table->integer('database_id')->unsigned();
			$table->integer('entity_id')->unsigned();
			$table->char('role_id', 2);
			$table->string('email');
			$table->string('env')->default(''dev'');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('invites');
	}
}