<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFaqsTable extends Migration {

	public function up()
	{
		Schema::create('faqs', function(Blueprint $table) {
			$table->increments('id');
			$table->string('question');
			$table->string('slug');
			$table->text('answer');
			$table->bigInteger('category_id')->unsigned()->nullable();
			$table->integer('list_order')->nullable()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('faqs');
	}
}