<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMegamenusTable extends Migration {

	public function up()
	{
		Schema::create('megamenus', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title');
			$table->string('link');
			$table->boolean('haschild')->default(0);
			$table->longText('children')->nullable();
			$table->integer('sort')->default('0');
			$table->tinyInteger('isviewall')->default('0');
			$table->tinyInteger('ismegamenu')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('megamenus');
	}
}