<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->string('name');
			$table->increments('id');
			$table->string('email')->unique();
			$table->string('password');
			$table->string('phone')->unique();
			$table->tinyInteger('status')->default('1');
			$table->string('image')->nullable();
			$table->integer('block_number');
			$table->datetime('last_block_date');
			$table->enum('login_type', array('apple', 'google', 'facebook'))->nullable();
			$table->datetime('login_date')->nullable();
			$table->datetime('first_suspension_period')->nullable();
			$table->datetime('last_suspension_period')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}