<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGovernoratesTable extends Migration {

	public function up()
	{
		Schema::create('governorates', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->text('name');
			$table->integer('country_id')->unsigned();
			$table->float('local_shipping_price')->default('0');
			$table->boolean('status')->default(1);
		});
	}

	public function down()
	{
		Schema::drop('governorates');
	}
}