<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->float('price');
			$table->string('product_id');
			$table->string('asku');
			$table->integer('quantity');
			$table->string('warranty_period');
			$table->boolean('warranty_status')->default(1);
			$table->string('product_status');
			$table->string('discount');
			$table->date('discount_date_from');
			$table->date('discount_date_to');
			$table->bigInteger('sub_category_id')->unsigned();
			$table->bigInteger('engine_id')->unsigned();
			$table->string('images');
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}