<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePhoneVerificationsTable extends Migration {

	public function up()
	{
		Schema::create('phone_verifications', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('phone')->unique();
			$table->string('verification_code')->unique();
			$table->boolean('verified')->default(0);
			$table->timestamp('expires_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('phone_verifications');
	}
}