<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Courses extends Model 
{

    protected $table = 'courses';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function enrollment()
    {
        return $this->hasOne('Enrollment');
    }

    public function categort()
    {
        return $this->belongsTo('Category');
    }

    public function payment()
    {
        return $this->hasMany('Payment');
    }

    public function teacher()
    {
        return $this->belongsTo('Teacher');
    }

}