<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Enrollment extends Model 
{

    protected $table = 'enrollment';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function course()
    {
        return $this->belongsToMany('Courses');
    }

    public function user()
    {
        return $this->belongsTo('Users');
    }

}