<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCoursesTable extends Migration {

	public function up()
	{
		Schema::create('courses', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('teacher_id');
			$table->integer('category_id');
			$table->string('title');
			$table->string('sub_title')->nullable();
			$table->longText('description');
			$table->integer('duration_in_hours');
			$table->string('video_url');
			$table->float('price')->nullable();
			$table->integer('discount')->nullable();
			$table->integer('discount_price')->nullable();
			$table->longText('refund_policy');
			$table->string('image_url')->nullable();
			$table->longText('what_will_learn')->nullable();
			$table->string('prerequisite');
			$table->longText('requirements')->nullable();
			$table->integer('view_count')->nullable()->default('0');
			$table->integer('status')->default('0');
			$table->integer('rating')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('courses');
	}
}