<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTeachersTable extends Migration {

	public function up()
	{
		Schema::create('teachers', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->string('profile');
			$table->longText('bio')->nullable();
			$table->string('profile_photo')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('teachers');
	}
}