<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('membership_id')->references('id')->on('memberships')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('vendors', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('product_images', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->foreign('color_id')->references('id')->on('product_colors')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('favoraties', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('favoraties', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('auction_participants', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('auction_participants', function(Blueprint $table) {
			$table->foreign('auction_id')->references('id')->on('auctions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cards', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('product_colors', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('set null')
						->onUpdate('set null');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_membership_id_foreign');
		});
		Schema::table('vendors', function(Blueprint $table) {
			$table->dropForeign('vendors_category_id_foreign');
		});
		Schema::table('product_images', function(Blueprint $table) {
			$table->dropForeign('product_images_product_id_foreign');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->dropForeign('carts_user_id_foreign');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->dropForeign('carts_product_id_foreign');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->dropForeign('carts_color_id_foreign');
		});
		Schema::table('favoraties', function(Blueprint $table) {
			$table->dropForeign('favoraties_user_id_foreign');
		});
		Schema::table('favoraties', function(Blueprint $table) {
			$table->dropForeign('favoraties_product_id_foreign');
		});
		Schema::table('auction_participants', function(Blueprint $table) {
			$table->dropForeign('auction_participants_user_id_foreign');
		});
		Schema::table('auction_participants', function(Blueprint $table) {
			$table->dropForeign('auction_participants_auction_id_foreign');
		});
		Schema::table('cards', function(Blueprint $table) {
			$table->dropForeign('cards_user_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_user_id_foreign');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->dropForeign('order_items_order_id_foreign');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->dropForeign('order_items_product_id_foreign');
		});
		Schema::table('product_colors', function(Blueprint $table) {
			$table->dropForeign('product_colors_product_id_foreign');
		});
	}
}