<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255)->index();
			$table->string('username')->unique();
			$table->string('email', 255)->unique();
			$table->string('password', 255);
			$table->string('phone', 255)->nullable();
			$table->string('location', 255)->nullable();
			$table->enum('gender', array(''))->nullable();
			$table->string('avatar_path', 255)->nullable();
			$table->string('facebook_id', 255)->nullable();
			$table->string('facebook_token', 255)->nullable();
			$table->string('facebook_refresh_token', 255)->nullable();
			$table->string('facebook_photo', 255);
			$table->string('email_verification_token')->nullable();
			$table->integer('active')->default('1');
			$table->integer('ranking')->default('0');
			$table->integer('scores')->default('0');
			$table->integer('questions_sent')->default('0');
			$table->string('background_path')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}