<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Usuario', function(Blueprint $table) {
			$table->foreign('idCatUsuario')->references('idCatUsuario')->on('CatUsuario')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Material', function(Blueprint $table) {
			$table->foreign('idCatUbicacion')->references('idCatUbicacion')->on('CatUbicacion')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Herramienta', function(Blueprint $table) {
			$table->foreign('idCatUbicacion')->references('idCatUbicacion')->on('CatUbicacion')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Equipo', function(Blueprint $table) {
			$table->foreign('idCatUbicacion')->references('idCatUbicacion')->on('CatUbicacion')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Solicitud', function(Blueprint $table) {
			$table->foreign('idUsuario')->references('idUsuario')->on('Usuario')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('BitacoraMaterial', function(Blueprint $table) {
			$table->foreign('idSolicitud')->references('idSolicitud')->on('Solicitud')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('BitacoraMaterial', function(Blueprint $table) {
			$table->foreign('idMaterial')->references('idMaterial')->on('Material')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('BitacoraHerramienta', function(Blueprint $table) {
			$table->foreign('idSolicitud')->references('idSolicitud')->on('Solicitud')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('BitacoraHerramienta', function(Blueprint $table) {
			$table->foreign('idHerramienta')->references('idHerramienta')->on('Herramienta')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Maquinaria', function(Blueprint $table) {
			$table->foreign('idCatUbicacion')->references('idCatUbicacion')->on('CatUbicacion')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('BitacoraMaquinaria', function(Blueprint $table) {
			$table->foreign('idSolicitud')->references('idSolicitud')->on('Solicitud')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('BitacoraMaquinaria', function(Blueprint $table) {
			$table->foreign('idMaquinaria')->references('idMaquinaria')->on('Maquinaria')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('BitacoraEquipo', function(Blueprint $table) {
			$table->foreign('idSolicitud')->references('idSolicitud')->on('Solicitud')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('BitacoraEquipo', function(Blueprint $table) {
			$table->foreign('idEquipo')->references('idEquipo')->on('Equipo')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Vehiculo', function(Blueprint $table) {
			$table->foreign('idCatTipoVehiculo')->references('idCatTipoVehiculo')->on('CatTipoVehiculo')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Vehiculo', function(Blueprint $table) {
			$table->foreign('idCatMarca')->references('idCatMarca')->on('CatMarca')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Vehiculo', function(Blueprint $table) {
			$table->foreign('idCatTransmision')->references('idCatTransmision')->on('CatTransmision')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('BitacoraVehiculo', function(Blueprint $table) {
			$table->foreign('idSolicitud')->references('idSolicitud')->on('Solicitud')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('BitacoraVehiculo', function(Blueprint $table) {
			$table->foreign('idVehiculo')->references('idVehiculo')->on('Vehiculo')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('DetalleBitacoraVehiculo', function(Blueprint $table) {
			$table->foreign('idBitacoraVehiculo')->references('idBitacoraVehiculo')->on('BitacoraVehiculo')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('DetalleBitacoraVehiculo', function(Blueprint $table) {
			$table->foreign('idCatVehiculoDescripcion')->references('idCatVehiculoDescripcion')->on('CatVehiculoDescripcion')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Usuario', function(Blueprint $table) {
			$table->dropForeign('Usuario_idCatUsuario_foreign');
		});
		Schema::table('Material', function(Blueprint $table) {
			$table->dropForeign('Material_idCatUbicacion_foreign');
		});
		Schema::table('Herramienta', function(Blueprint $table) {
			$table->dropForeign('Herramienta_idCatUbicacion_foreign');
		});
		Schema::table('Equipo', function(Blueprint $table) {
			$table->dropForeign('Equipo_idCatUbicacion_foreign');
		});
		Schema::table('Solicitud', function(Blueprint $table) {
			$table->dropForeign('Solicitud_idUsuario_foreign');
		});
		Schema::table('BitacoraMaterial', function(Blueprint $table) {
			$table->dropForeign('BitacoraMaterial_idSolicitud_foreign');
		});
		Schema::table('BitacoraMaterial', function(Blueprint $table) {
			$table->dropForeign('BitacoraMaterial_idMaterial_foreign');
		});
		Schema::table('BitacoraHerramienta', function(Blueprint $table) {
			$table->dropForeign('BitacoraHerramienta_idSolicitud_foreign');
		});
		Schema::table('BitacoraHerramienta', function(Blueprint $table) {
			$table->dropForeign('BitacoraHerramienta_idHerramienta_foreign');
		});
		Schema::table('Maquinaria', function(Blueprint $table) {
			$table->dropForeign('Maquinaria_idCatUbicacion_foreign');
		});
		Schema::table('BitacoraMaquinaria', function(Blueprint $table) {
			$table->dropForeign('BitacoraMaquinaria_idSolicitud_foreign');
		});
		Schema::table('BitacoraMaquinaria', function(Blueprint $table) {
			$table->dropForeign('BitacoraMaquinaria_idMaquinaria_foreign');
		});
		Schema::table('BitacoraEquipo', function(Blueprint $table) {
			$table->dropForeign('BitacoraEquipo_idSolicitud_foreign');
		});
		Schema::table('BitacoraEquipo', function(Blueprint $table) {
			$table->dropForeign('BitacoraEquipo_idEquipo_foreign');
		});
		Schema::table('Vehiculo', function(Blueprint $table) {
			$table->dropForeign('Vehiculo_idCatTipoVehiculo_foreign');
		});
		Schema::table('Vehiculo', function(Blueprint $table) {
			$table->dropForeign('Vehiculo_idCatMarca_foreign');
		});
		Schema::table('Vehiculo', function(Blueprint $table) {
			$table->dropForeign('Vehiculo_idCatTransmision_foreign');
		});
		Schema::table('BitacoraVehiculo', function(Blueprint $table) {
			$table->dropForeign('BitacoraVehiculo_idSolicitud_foreign');
		});
		Schema::table('BitacoraVehiculo', function(Blueprint $table) {
			$table->dropForeign('BitacoraVehiculo_idVehiculo_foreign');
		});
		Schema::table('DetalleBitacoraVehiculo', function(Blueprint $table) {
			$table->dropForeign('DetalleBitacoraVehiculo_idBitacoraVehiculo_foreign');
		});
		Schema::table('DetalleBitacoraVehiculo', function(Blueprint $table) {
			$table->dropForeign('DetalleBitacoraVehiculo_idCatVehiculoDescripcion_foreign');
		});
	}
}