<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBitacoraVehiculoTable extends Migration {

	public function up()
	{
		Schema::create('BitacoraVehiculo', function(Blueprint $table) {
			$table->increments('idBitacoraVehiculo');
			$table->integer('idSolicitud')->unsigned();
			$table->integer('idVehiculo')->unsigned();
			$table->string('gasolinaPrestamo', 10)->nullable();
			$table->string('aceitePrestamo', 25)->nullable();
			$table->string('anticogelantePrestamo', 25)->nullable();
			$table->string('odometroIniciaPrestamo', 25)->nullable();
			$table->string('odometroTerminaPrestamo', 25)->nullable();
			$table->string('kmActualPrestamo', 25)->nullable();
			$table->string('observacionesPrestamo', 250)->nullable();
			$table->string('gasolinaRecepcion', 10)->nullable();
			$table->datetime('fechaPrestamo');
			$table->string('aceiteRecepcion', 25)->nullable();
			$table->string('anticogelanteRecepcion', 25);
			$table->string('odometroIniciaRecepcion', 25)->nullable();
			$table->string('odometroTerminaRecepcion', 25)->nullable();
			$table->string('kmActualRecepcion', 25)->nullable();
			$table->string('observacionesRecepcion', 250)->nullable();
			$table->datetime('fechaRecepcion');
		});
	}

	public function down()
	{
		Schema::drop('BitacoraVehiculo');
	}
}