<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVehiculoTable extends Migration {

	public function up()
	{
		Schema::create('Vehiculo', function(Blueprint $table) {
			$table->increments('idVehiculo');
			$table->string('nombre', 100);
			$table->string('modelo', 15);
			$table->integer('idCatTipoVehiculo')->unsigned();
			$table->integer('idCatMarca')->unsigned();
			$table->string('placas', 15);
			$table->string('color', 25);
			$table->date('polizaSeguro');
			$table->string('version', 50)->nullable();
			$table->integer('idCatTransmision')->unsigned();
			$table->string('estado', 10)->default('Bueno');
			$table->string('gasolina', 10)->nullable();
			$table->string('aceite', 25)->nullable();
			$table->string('anticogelante', 25)->nullable();
			$table->string('odometroInicia', 25)->nullable();
			$table->string('odometroTermina', 25)->nullable();
			$table->string('kmActual', 25)->nullable();
			$table->string('observaciones', 250);
		});
	}

	public function down()
	{
		Schema::drop('Vehiculo');
	}
}