<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTemplateQuestionsTable extends Migration {

	public function up()
	{
		Schema::create('template_questions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('template_version_id')->unique()->unsigned();
			$table->integer('question_id')->unique()->unsigned();
			$table->integer('sort_order')->default('0');
			$table->date('created_at');
			$table->date('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('template_questions');
	}
}