<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRequirementsTable extends Migration {

	public function up()
	{
		Schema::create('requirements', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->enum('level', array(''));
			$table->integer('package_id')->unsigned();
			$table->integer('service_id')->unsigned();
			$table->string('name');
			$table->text('description')->nullable();
			$table->boolean('is_mandatory');
		});
	}

	public function down()
	{
		Schema::drop('requirements');
	}
}