<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAnswersTable extends Migration {

	public function up()
	{
		Schema::create('answers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('report_submission_id')->unsigned();
			$table->integer('template_question_id')->unsigned();
			$table->text('value');
			$table->boolean('compliant')->nullable();
			$table->integer('weight')->nullable();
			$table->date('created_at');
			$table->date('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('answers');
	}
}