<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateApplicationsTable extends Migration {

	public function up()
	{
		Schema::create('applications', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('facility_id')->unique()->unsigned();
			$table->integer('user_id')->unique()->unsigned();
			$table->bigInteger('package_id')->unsigned();
			$table->string('status');
			$table->string('rejection_reason');
			$table->date('created_at');
			$table->string('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('applications');
	}
}