<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAttachmentLinksTable extends Migration {

	public function up()
	{
		Schema::create('attachment_links', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('attachment_id')->unsigned()->index();
			$table->string('attachable_type')->index();
			$table->bigInteger('attachable_id');
			$table->date('created_at');
			$table->date('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('attachment_links');
	}
}