<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFacilityServicesTable extends Migration {

	public function up()
	{
		Schema::create('facility_services', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('facility_package_id')->unique()->unsigned();
			$table->integer('service_id')->unique()->unsigned();
			$table->integer('visit_count')->default('0');
			$table->string('status');
			$table->string('created_at');
			$table->string('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('facility_services');
	}
}