<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePackageServicesTable extends Migration {

	public function up()
	{
		Schema::create('package_services', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('package_id')->unique()->unsigned();
			$table->integer('service_id')->unique()->unsigned();
			$table->integer('default_visits')->default('0');
			$table->integer('sort_order')->default('0');
			$table->date('created_at');
			$table->date('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('package_services');
	}
}