<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuestionOptionsTable extends Migration {

	public function up()
	{
		Schema::create('question_options', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('question_id')->unique()->unsigned();
			$table->string('value');
			$table->string('label')->nullable();
			$table->integer('sort_order')->default('0');
			$table->date('created_at');
			$table->date('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('question_options');
	}
}