<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReportSubmissionsTable extends Migration {

	public function up()
	{
		Schema::create('report_submissions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('appointment_id')->unsigned();
			$table->integer('inspector_id')->unsigned();
			$table->datetime('started_at')->nullable();
			$table->datetime('submitted_at')->nullable();
			$table->string('status');
			$table->decimal('compliance_percentage')->default('0');
			$table->string('pdf_url')->nullable();
			$table->date('created_at');
			$table->date('updated_at');
			$table->integer('verified_by')->unsigned()->nullable();
			$table->datetime('verified_at')->nullable();
			$table->text('review_notes')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('report_submissions');
	}
}