<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateViolationsTable extends Migration {

	public function up()
	{
		Schema::create('violations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('code')->unique();
			$table->string('title');
			$table->text('description');
			$table->decimal('fine_amount')->nullable();
			$table->date('created_at');
			$table->date('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('violations');
	}
}