<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Person extends Eloquent {

	protected $table = 'people';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user()
	{
		return $this->hasOne('App\Models\User');
	}

	public function company()
	{
		return $this->hasOne('App\Models\Company');
	}

}