<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOauthIndentitiesTable extends Migration {

	public function up()
	{
		Schema::create('oauth_indentities', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->string('provider', 100)->unique();
			$table->string('provider_id', 255)->unique()->nullable();
			$table->string('access_token', 255);
			$table->string('name', 255)->nullable();
			$table->string('avatar', 255)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('oauth_indentities');
	}
}