<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProfilesTable extends Migration {

	public function up()
	{
		Schema::create('profiles', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->string('address', 255)->nullable();
			$table->tinyInteger('gender')->default('2');
			$table->timestamp('dob')->nullable();
			$table->string('phone', 50)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('profiles');
	}
}