<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('Orders', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('feature_set_id');
			$table->uuid('merchant_id');
			$table->string('status', 50);
			$table->string('payment_frequency', 50);
			$table->smallInteger('quantity');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Orders');
	}
}