<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFilesTable extends Migration {

	public function up()
	{
		Schema::create('files', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('parent_id')->nullable();
			$table->string('name')->nullable();
			$table->string('alter_text')->nullable();
			$table->string('size')->nullable();
			$table->string('mime_type')->nullable();
			$table->string('extention')->nullable();
			$table->string('slug')->nullable();
			$table->string('path')->nullable();
			$table->integer('image_id')->nullable();
			$table->string('color')->nullable();
			$table->smallInteger('items_count')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('files');
	}
}