<?php

namespace App\Models;

class Car extends Eloquent {

	protected $table = 'cars';
	public $timestamps = true;
	protected $fillable = array('car_status_id', 'licence_plate', 'manufacturer', 'model', 'engine_capacity', 'service_start', 'certificate_valid');

	public function user_car()
	{
		return $this->hasMany('UserCar', 'car_id');
	}

	public function engineType()
	{
		return $this->hasOne('EngineType');
	}

	public function carType()
	{
		return $this->hasOne('CarType');
	}

	public function station()
	{
		return $this->hasOne('Station');
	}

	public function car_status()
	{
		return $this->hasOne('CarStatus');
	}

}