<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserCarsTable extends Migration {

	public function up()
	{
		Schema::create('user_cars', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('car_id')->unsigned()->index();
			$table->bigInteger('user_id')->unsigned()->index();
			$table->tinyInteger('active')->default('0');
			$table->datetime('assign_start');
			$table->datetime('assign_end')->nullable();
			$table->integer('distance_limit')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('user_cars');
	}
}