<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCarsTable extends Migration {

	public function up()
	{
		Schema::create('cars', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('engine_type')->unsigned();
			$table->bigInteger('car_type_id')->unsigned()->index();
			$table->bigInteger('car_status_id')->unsigned()->index();
			$table->bigInteger('station_id')->unsigned()->index();
			$table->string('licence_plate', 10)->index();
			$table->string('manufacturer', 40);
			$table->string('model', 40);
			$table->smallInteger('engine_capacity')->nullable();
			$table->date('service_start');
			$table->date('certificate_valid');
			$table->string('VIN', 40)->nullable();
			$table->mediumInteger('mileage')->nullable();
			$table->mediumInteger('service_distance');
		});
	}

	public function down()
	{
		Schema::drop('cars');
	}
}