<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContractTable extends Migration {

	public function up()
	{
		Schema::create('contract', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('company');
			$table->mediumInteger('monthly_fee');
			$table->bigInteger('car_id')->unsigned()->index();
			$table->date('contract_start');
			$table->date('contract_end');
		});
	}

	public function down()
	{
		Schema::drop('contract');
	}
}