<?php

namespace app;

use Illuminate\Database\Eloquent\Model;

class Revaluasi extends Model 
{

    protected $table = 'revaluasi';
    public $timestamps = true;
    protected $fillable = array('id_tahun', 'id_sektor', 'id_perusahaan', 'jumlah_aset', 'status');

    public function tahun()
    {
        return $this->hasMany('Tahun', 'id_tahun');
    }

    public function sektor()
    {
        return $this->hasMany('Sektor', 'id_sektor');
    }

    public function perusahaan()
    {
        return $this->hasMany('Perusahaan', 'id_perusahaan');
    }

}